/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.FactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.Populator;

public class FactPopulator {
    private Map<String, Populator> toBePopulatedData = new HashMap<String, Populator>();
    private final Map<String, Object> populatedData;
    private final Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private final InternalWorkingMemory workingMemory;

    public FactPopulator(InternalWorkingMemory workingMemory, Map<String, Object> populatedData) {
        this.workingMemory = workingMemory;
        this.populatedData = populatedData;
    }

    public void populate() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList<FieldPopulator> fieldPopulators = new ArrayList<FieldPopulator>();
        for (Populator populator : this.toBePopulatedData.values()) {
            fieldPopulators.addAll(populator.getFieldPopulators());
        }
        for (FieldPopulator fieldPopulator : fieldPopulators) {
            fieldPopulator.populate(this.populatedData);
        }
        for (Populator populator : this.toBePopulatedData.values()) {
            populator.populate(this.workingMemory, this.factHandles);
        }
        this.toBePopulatedData.clear();
    }

    public void retractFact(String retractFactName) {
        this.workingMemory.retract(this.factHandles.get(retractFactName));
        this.populatedData.remove(retractFactName);
    }

    public void add(Populator factPopulator) {
        this.toBePopulatedData.put(factPopulator.getName(), factPopulator);
    }
}

